package com.futurelytics.springaoppoc.aop;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

/**
 *
 * @author Petr Giecek
 */
@Aspect
@Component
public class AddMarkupAdvice {

    @Around(value = "@annotation(addMarkup)", argNames = "addMarkup")
    public String grantPrincipal(ProceedingJoinPoint pjp, AddMarkup addMarkup) throws Throwable{

        Object returnValue = pjp.proceed();

        return addMarkup.before() + returnValue + addMarkup.after();
    }

}
